definition module receiverhandle


//	Clean Object I/O library, version 1.1


import	id, receivermessage
from	ostoolbox	import OSToolbox

::	ReceiverHandles ps
	=	{	rReceivers	:: [ReceiverStateHandle ps]
		}
::	ReceiverStateHandle ps
	=	E..ls:
		{	rState		:: ls							// If has local state then [_], otherwise []
		,	rHandle		:: ReceiverHandle ls ps			// The receiver handle
		}
::	ReceiverHandle ls ps
	=	E.m r:
		{	rId			:: Id							// The id of the receiver
		,	rASMQ		:: [m]							// The asynchronous message queue
		,	rSelect		:: SelectState					// The attribute ReceiverSelect==Able (default True)
		,	rOneWay		:: Bool							// The receiver definition was Receiver (not Receiver2)
		,	rFun		:: RHandleFunction ls m r ps	// If rOneWay then [r]==[], otherwise [r]==[_]
		,	rInetInfo	:: !Maybe !(!EndpointRef`,!InetReceiverCategory`,!Int,!IdFun !*OSToolbox)
														// For internet receivers
		,	rConnected	:: ![!Id]						// storing the argument of the ReceiverCloseAlsoReceivers attribute
		}
::	RHandleFunction ls m r ps
	:==	m -> (ls,ps) -> (ls,[r],ps)

::	InetReceiverASMQType	:== (!InetEvent`,!EndpointRef`,!Int)

::	InetEvent`				:== Int
::	EndpointRef`			:==	Int
::	InetReceiverCategory`	:==	Int

receiverIdentified			:: !Id					!(ReceiverHandle .ls .ps)	-> Bool
inetReceiverIdentified		::	!(!EndpointRef`, !InetReceiverCategory`)
								!(ReceiverHandle .ls .ps)	-> Bool
inetReceiverIdentifiedWithId::	!(!Id, !InetReceiverCategory`)
								!(ReceiverHandle .ls .ps)	-> Bool
receiverSetSelectState		:: !SelectState			!(ReceiverStateHandle .ps)	-> ReceiverStateHandle .ps
receiverSetFunction			:: !Id (RHandleFunction .ls m r .ps)
													!(ReceiverStateHandle .ps)	-> ReceiverStateHandle .ps
receiverHandleSyncMessage	:: !(SyncMessage m r)	!(ReceiverHandle .ls .ps) (.ls,.ps)
											  -> ([r],ReceiverHandle .ls .ps, (.ls,.ps))
receiverAddASyncMessage		:: !Id m				!(ReceiverHandle .ls .ps)	-> ReceiverHandle .ls .ps
receiverApplyInetEvent		::	!InetReceiverASMQType !(ReceiverHandle .ls .ps) (.ls,.ps)
							->	(.ls,.ps)
getInetReceiverRId			::	!(ReceiverHandle .ls .ps)	-> (RId InetReceiverASMQType)
